<?php
session_start();
error_reporting(E_ALL);
ini_set('display_errors', 1);
require_once 'config/database.php';
require_once 'includes/header.php';

if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit();
}

try {
    $database = new Database();
    $db = $database->getConnection();

    // Filtros
    $data_inicio = isset($_GET['data_inicio']) ? $_GET['data_inicio'] : date('Y-m-01');
    $data_fim = isset($_GET['data_fim']) ? $_GET['data_fim'] : date('Y-m-t');
    $status = isset($_GET['status']) ? $_GET['status'] : 'todos';

    // Construir a query
    $sql = "SELECT 
                c.*,
                DATE_FORMAT(c.data_troca, '%d/%m/%Y') as data_troca_formatada,
                DATE_FORMAT(c.data_vencimento, '%d/%m/%Y') as data_vencimento_formatada
            FROM cheques c 
            WHERE c.user_id = :user_id 
            AND DATE(c.data_troca) BETWEEN :data_inicio AND :data_fim";

    if ($status !== 'todos') {
        $sql .= " AND c.status_pagamento = :status";
    }

    $sql .= " ORDER BY c.data_troca DESC";

    $stmt = $db->prepare($sql);
    $stmt->bindValue(':user_id', $_SESSION['user_id']);
    $stmt->bindValue(':data_inicio', $data_inicio);
    $stmt->bindValue(':data_fim', $data_fim);

    if ($status !== 'todos') {
        $stmt->bindValue(':status', $status);
    }

    $stmt->execute();
    $cheques = $stmt->fetchAll(PDO::FETCH_ASSOC);

    // Calcular totais
    $total_cheques = 0;
    $total_valor = 0;
    $total_juros = 0;
    $total_liquido = 0;

    foreach ($cheques as $cheque) {
        $total_cheques++;
        $total_valor += $cheque['valor'];
        $total_juros += $cheque['juros'];
        $total_liquido += $cheque['valor_liquido'];
    }
} catch (Exception $e) {
    die("Erro ao carregar relatório: " . $e->getMessage());
}
?>

<div class="main-container">
    <div class="header">
        <h1>Relatórios</h1>
    </div>
    
    <div class="main-content">
        <form method="GET" class="filtros no-print">
            <div class="form-group">
                <label for="data_inicio">Data Inicial</label>
                <input type="date" id="data_inicio" name="data_inicio" value="<?php echo $data_inicio; ?>">
            </div>
            <div class="form-group">
                <label for="data_fim">Data Final</label>
                <input type="date" id="data_fim" name="data_fim" value="<?php echo $data_fim; ?>">
            </div>
            <div class="form-group">
                <label for="status">Status</label>
                <select id="status" name="status">
                    <option value="todos" <?php echo $status == 'todos' ? 'selected' : ''; ?>>Todos</option>
                    <option value="pendente" <?php echo $status == 'pendente' ? 'selected' : ''; ?>>Pendente</option>
                    <option value="pago" <?php echo $status == 'pago' ? 'selected' : ''; ?>>Pago</option>
                </select>
            </div>
            <div class="form-group" style="align-self: end;">
                <button type="submit" class="btn-filtrar">Filtrar</button>
                <button type="button" class="btn-imprimir" onclick="window.print()">Imprimir</button>
            </div>
        </form>

        <div class="resumo">
            <div class="resumo-item">
                <h3>Total de Cheques</h3>
                <p><?php echo $total_cheques; ?></p>
            </div>
            <div class="resumo-item">
                <h3>Valor Total</h3>
                <p>R$ <?php echo number_format((float)$total_valor, 2, ',', '.'); ?></p>
            </div>
            <div class="resumo-item">
                <h3>Total de Juros</h3>
                <p>R$ <?php echo number_format((float)$total_juros, 2, ',', '.'); ?></p>
            </div>
            <div class="resumo-item">
                <h3>Valor Líquido Total</h3>
                <p>R$ <?php echo number_format((float)$total_liquido, 2, ',', '.'); ?></p>
            </div>
        </div>

        <div class="table-responsive">
            <table>
                <thead>
                    <tr>
                        <th>Cliente</th>
                        <th>Nº Cheque</th>
                        <th>Banco</th>
                        <th>Data Troca</th>
                        <th>Vencimento</th>
                        <th>Valor</th>
                        <th>Juros</th>
                        <th>Valor Líquido</th>
                        <th>Status</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($cheques as $cheque): ?>
                        <tr>
                            <td><?php echo ($cheque['cliente'] ?? ''); ?></td>
                            <td><?php echo htmlspecialchars($cheque['numero_cheque'] ?? ''); ?></td>
                            <td><?php echo htmlspecialchars($cheque['banco'] ?? ''); ?></td>
                            <td><?php echo $cheque['data_troca_formatada']; ?></td>
                            <td><?php echo $cheque['data_vencimento_formatada']; ?></td>
                            <td>R$ <?php echo number_format((float)$cheque['valor'], 2, ',', '.'); ?></td>
                            <td>R$ <?php echo number_format((float)$cheque['juros'], 2, ',', '.'); ?></td>
                            <td>R$ <?php echo number_format((float)$cheque['valor_liquido'], 2, ',', '.'); ?></td>
                            <td class="status-<?php echo $cheque['status_pagamento']; ?>">
                                <?php echo ucfirst($cheque['status_pagamento']); ?>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>

<?php
require_once 'includes/footer.php';
?>
